/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.capabilities.ChopSettingsProvider;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.event.ChopEvent;
import ht.treechop.common.network.PacketHandler;
import ht.treechop.common.util.ChopResult;
import ht.treechop.common.util.ChopUtil;
import ht.treechop.common.util.FauxPlayerInteractionManager;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Common {
    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        ChopSettingsCapability.register();
        PacketHandler.init();
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        ConfigHandler.updateTags(event.getTagManager());
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        ItemStack tool = event.getPlayer().func_184614_ca();
        BlockState blockState = event.getState();
        BlockPos pos = event.getPos();
        if (!(ChopUtil.isBlockALog(blockState) && ((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() && ChopUtil.canChopWithTool(tool) && !event.isCanceled() && event.getWorld() instanceof ServerWorld && event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        ServerPlayerEntity agent = (ServerPlayerEntity)event.getPlayer();
        if (!ChopUtil.playerWantsToChop((PlayerEntity)agent)) {
            if (ConfigHandler.shouldOverrideItemBehavior(tool.func_77973_b(), false)) {
                FauxPlayerInteractionManager.harvestBlockSkippingOnBlockStartBreak(agent, world, blockState, pos, event.getExpToDrop());
                event.setCanceled(true);
            }
            return;
        }
        ChopEvent.StartChopEvent startChopEvent = new ChopEvent.StartChopEvent(event, (World)world, (PlayerEntity)agent, pos, blockState, ChopUtil.getNumChopsByTool(tool, blockState), ChopUtil.playerWantsToFell((PlayerEntity)agent));
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)startChopEvent);
        if (canceled) {
            return;
        }
        ChopResult chopResult = ChopUtil.getChopResult((World)world, pos, (PlayerEntity)agent, startChopEvent.getNumChops(), startChopEvent.getFelling(), logPos -> ChopUtil.isBlockALog((IWorld)world, logPos));
        if (chopResult != ChopResult.IGNORED) {
            if (chopResult.apply(pos, (PlayerEntity)agent, tool, (Boolean)ConfigHandler.COMMON.breakLeaves.get())) {
                event.setCanceled(true);
                if (!agent.func_184812_l_()) {
                    ChopUtil.doItemDamage(tool, (World)world, blockState, pos, (PlayerEntity)agent);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new ChopEvent.FinishChopEvent((World)world, (PlayerEntity)agent, pos, blockState));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        ResourceLocation loc = new ResourceLocation("treechopchop_settings_capability");
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(loc, (ICapabilityProvider)new ChopSettingsProvider());
        }
    }
}

